--[[
This is the TailExpert Lua configuration script

]]--
dbg = require 'debugger'
require("CLRPackage")
local inspect = require("inspect")

function __OnTerminate__()
	error()
end

function __OnEnter__()
	intputBuffer = {}
	outputBuffer = {}
	OnEnter()
end

function __OnExit__()
	OnExit()
	intputBuffer = {}
	outputBuffer = {}
end

function __OnEvaluate__()
	outputBuffer = {}
	OnEvaluate(inputBuffer)
end

--[[
    Utility functions
]]--

function PutLogLine(line)
	table.insert(outputBuffer, line)
end

function PutLogLines(lines)
	for i=1,#lines,1 do
		PrintLine(lines[i])
	end
end

function GetLogLines()
    return inputBuffer;
end

function fsize (file)
    local current = file:seek()      -- get current position
    local size = file:seek("end")    -- get file size
    file:seek("set", current)        -- restore position
    return size
end 

function feof (file)
    local current = file:seek()      -- get current position
    local size = file:seek("end")    -- get file size
    file:seek("set", current)        -- restore position
    return (size == current)
end 

-- see if the file exists
function file_exists(file)
  local f = io.open(file, "r")
  if f then f:close() end
  return f ~= nil
end

-- Define loglevels
DEBUG = 0
INFO = 1
ERROR = 2
FATAL = 3
MAXLOGLEVEL=3

-- Define default Column
ALLCOLUMNS = "All Columns"

-- Define filter operations
CONTAINS = "CONTAINS"
CONTAINSNOT = "CONTAINSNOT"
EQUAL = "EQUAL"
NOTEQUAL = "NOTEQUAL"
GREATER = "GREATER"
SMALLER = "SMALLER"
GREATEREQUAL = "GREATEREQUAL"
SMALLEREQUAL = "SMALLEREQUAL"
BETWEEN = "BETWEEN"
OUTSIDE = "OUTSIDE"
BETWEENINCLUDING = "BETWEENINCLUDING" 
OUTSIDEINCLUDING = "OUTSIDEINCLUDING"
-- Signal that script is initialized
ScriptInitialized = false
KeepLuaWindow = true

-- Set PassThrough mode, lua modifications to incoming lines are copied back into tail buffer 
PassThrough = false

-- Define input and output buffers
InputBufferName = "inputBuffer"
OutputBufferName = "outputBuffer"
inputBuffer = {}
outputBuffer = {}

