--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script will read a file named TailExpert.log from the temp directory 
    and submit it to TailExpert, the script will search for messages that indicate
	the usage of internal functions. To get a visible pie graph the 
	TailExpert debuglogging should be enabled to get the logfile filled with 
	the required debug messages.
]]--
require("Config")

-- Import Windows Assemblies
import("System")
import("System.Windows.Forms")
import("System.Drawing")
import("System.Drawing.Drawing2D")
import("ZedGraph") 
local graph = ZedGraphControl()
graph.Dock = DockStyle.Fill
myPane = graph.GraphPane

-- Set the pane title
myPane.Title.Text = "PieChart Example"

-- Enter some data values
local values = String[6]
values[0] = 15
values[1] = 15
values[2] = 15
values[3] = 15
values[4] = 15
values[5] = 15
local values2 = Double[6]
values2[0] = 0 
values2[1] = 0 
values2[2] = 0 
values2[3] = 0 
values2[4] = 0 
values2[5] = 0 
local colors = Color [6]
colors[0] = Color.Red
colors[1] = Color.Blue
colors[2] = Color.Green
colors[3] = Color.Yellow
colors[4] = Color.Orange
colors[5] = Color.Magenta
local displacement = Double [6]
displacement[0] = 0.0
displacement[1] = 0.0
displacement[2] = 0.0
displacement[3] = 0.0
displacement[4] = 0.0
displacement[5] = 0.0
local label = String [6]
label[0] = "Pause"
label[1] = "Scroll"
label[2] = "Filter"
label[3] = "Compare"
label[4] = "Bookmarks"
label[5] = "Group"

-- Fill the pane and axis background with solid color
myPane.Fill = Fill( Color.Cornsilk )
myPane.Chart.Fill = Fill( Color.Cornsilk )
myPane.Legend.Position = LegendPos.Right 
			
-- Sum up the values																					
local curves = myPane.CurveList 
local total = 0 
--for x=1,curves.count,1 do
--[[
for x=0,curves.Count,1 do
	pointPairList = PointPairList()
    pointPairList:Add(nil, values2)
	curveItem = myPane.CurveList[x]
    curveItem.Points = pointPairList
end
]]--
-- Add a text item to highlight total sales
local text = TextObj("Distribution of funtion usage in TailExpert", 0.85, 0.80, CoordType.PaneFraction )
text.Location.AlignH = AlignH.Center
text.Location.AlignV = AlignV.Bottom
text.FontSpec.Border.IsVisible = false 
text.FontSpec.Fill = Fill( Color.White, Color.PowderBlue, 45.0 )
text.FontSpec.StringAlignment = StringAlignment.Center 
myPane.GraphObjList:Add( text )
	
-- Add a colored background behind the pie
local box = BoxObj( 0, 0, 1, 1, Color.Empty, Color.PeachPuff )
box.Location.CoordinateFrame = CoordType.ChartFraction
box.Border.IsVisible = false
box.Location.AlignH = AlignH.Left
box.Location.AlignV = AlignV.Top
box.ZOrder = ZOrder.E_BehindCurves
myPane.GraphObjList:Add( box )

local dbl_arr = Double[6]

for i=0, 5,1 do
    dbl_arr[i] = 0.0
end

-- Create some pie slices
local segment1 = myPane:AddPieSlice ( dbl_arr[0], Color.Navy, .20, label[0]) 
local segment2 = myPane:AddPieSlice ( dbl_arr[1], Color.Salmon, 0, label[1]) 
local segment3 = myPane:AddPieSlice ( dbl_arr[2], Color.Yellow,.0, label[2]) 
local segment4 = myPane:AddPieSlice ( dbl_arr[3], Color.LimeGreen, 0, label[3]) 
local segment5 = myPane:AddPieSlice ( dbl_arr[4], Color.Aquamarine, .3, label[4]) 
local segment6 = myPane:AddPieSlice ( dbl_arr[5], Color.Magenta, .3, label[5]) 
-- Modify the slice label types
segment1.LabelType = PieLabelType.Name_Percent 
segment1.Value = dbl_arr[0];
segment2.LabelType = PieLabelType.Name_Percent 
segment2.Value = dbl_arr[1];
segment3.LabelType = PieLabelType.Name_Percent 
segment3.Value = dbl_arr[2];
segment4.LabelType = PieLabelType.Name_Percent 
segment4.Value = dbl_arr[3];
segment5.LabelType = PieLabelType.Name_Percent 
segment5.Value = dbl_arr[4];
segment6.LabelType = PieLabelType.Name_Percent 
segment6.Value = dbl_arr[5];
segment2.LabelDetail.FontSpec.FontColor = Color.Red 

local filename = 'Example2.log'
local file = nill

local linenr = 0
function ReadFile(f)
	-- Do not put message here as it will make a recurring effect when you have log enabled and load TailExpert.log
	outputBuffer = {}
	if ScriptInitialized == true then
		if feof(f) ~= nill then
			while feof(f) ~= true do
				local line = f:read("*line")
				if line ~= nill then 
					PutLogLine( line )
                    
					if string.match(line, "ButtonPause") ~= nil then
                        dbl_arr[0] = dbl_arr[0] + 1.0
					end
					if string.match(line, "ButtonScroll") ~= nil then
                        dbl_arr[1] = dbl_arr[1] + 1.0
					end
					if string.match(line, "ButtonFilter") ~= nil then
                        dbl_arr[2] = dbl_arr[2] + 1.0
					end
					if string.match(line, "compareTabs") ~= nil then
                        dbl_arr[3] = dbl_arr[3] + 1.0
					end
					if string.match(line, "Bookmark") ~= nil then
                        dbl_arr[4] = dbl_arr[4] + 1.0
					end
					if string.match(line, "find") ~= nil then
                        dbl_arr[4] = dbl_arr[4] + 1.0
					end
					if string.match(line, "Group") ~= nil then
                        dbl_arr[5] = dbl_arr[5] + 1.0
					end
				end
							
				segment1.Value = dbl_arr[0];
				segment2.Value = dbl_arr[1];
				segment3.Value = dbl_arr[2];
				segment4.Value = dbl_arr[3];
				segment5.Value = dbl_arr[4];
				segment6.Value = dbl_arr[5];
                graph:AxisChange()
                graph:Refresh()
			end
		end
	end
end

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
    if ScriptInitialized == true then
        ReadFile(file)
    end
end

-- Initialize this script
function OnEnter()
	LogMessage(INFO, "OpenCustomTab3.lua script OnEnter()")
    -- tests the functions above
	ScriptInitialized = true

    -- tests the functions above
    if file_exists(filename) then
        file = assert(io.open(filename, "r"))
    end
    file:seek("set", 0)
    local tab = OpenCustomTab("OpenCustomTab3", false)
	tab.Controls:Add(graph)
	graph:AxisChange()
	graph:Refresh()
end

-- Cleanup
function OnExit()
	LogMessage(INFO, "OpenCustomTab3.lua script OnExit()")
    graph:Dispose()
	file:close()
	CloseTab("OpenCustomTab3")
   	ScriptInitialized = false
end

