--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script will read a file named TailExpert.log from the temp directory 
    and submit it to TailExpert, all occurences of the word `error` will be 
    converted to uppercase before submission
]]--
require("Config")

filename = 'c:\\temp\\TailExpert.log'
file = nill

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
	if ScriptInitialized == true then
        local line = file:read("*line")
		line = string.lower(line)  -- make all chars lowercase
        if line ~= nill then 
            -- make every occurance of `error` uppercase before submitting the log to TailExpert
            string.gsub(line, "error", string.upper) 
			PutLogLine( line ) 
		end
    end
end

-- Initialize this script
function OnEnter()
	LogMessage(INFO, "ReadFile.lua script OnEnter()")
    -- tests the functions above
    if file_exists(filename) then
        file = io.open(filename, "r")
    	ScriptInitialized = true
    end
end

-- Cleanup
function OnExit()
	LogMessage(INFO, "ReadFile.lua script OnExit()")
   	ScriptInitialized = false
    file:close()
end

