--[[
This is an example script for the lua engine in TailExpert

]]--
require("Config")

-- Import WIndows Assemblies
import("System")
import("System.Windows.Forms")
import("System.Drawing")
import("System.Drawing.Drawing2D")

local form = Form()
form.Height = 300
form.Width = 500
form.Text = "Set Loglevel"
form.HelpButton=false
form.MaximizeBox=true
form.MinimizeBox=true
local radio1 = RadioButton()
radio1.Text = "DEBUG"
local radio2 = RadioButton()
radio2.Text = "INFO"
local radio3 = RadioButton()
radio3.Text = "WARNING"
local radio4 = RadioButton()
radio4.Text = "ERROR"
local button = Button()
button.Text = "Activate"


local label = Label()
label.AutoSize = true
label.Text = "Set Loglevel of target"
label.Location = Point((form.Width / 2) - (label.Width /2), 20)
form.Controls:Add(label)
LogMessage(ERROR, "label.X=" .. label.Location.X .. " label.Y=" .. label.Location.Y)
button.Location = Point((form.Width / 2) - (button.Width /2), (form.Height - 80))
form.Controls:Add(button)
radio1.Location = Point((form.Width / 2) - 20, 40)
form.Controls:Add(radio1)
radio2.Location = Point((form.Width / 2) - 20, 60)
radio2.Checked = true
form.Controls:Add(radio2)
radio3.Location = Point((form.Width / 2) - 20, 80)
form.Controls:Add(radio3)
radio4.Location = Point((form.Width / 2) - 20, 100)
form.Controls:Add(radio4)


-- SetLogLevel function 
-- This function is called when the "Activate" button is pressed and can be used to set a loglevel on the target which you are debugging
-- 
function SetLogLevel(level)

    -- Your code goes here

end

-- Button click handler
function clickButton()
    local levelstr = ""
    local level = 1  -- default level is INFO
    if (form~=nill) then
        if radio1.Checked == true then
           level = 0
           levelstr = "DEBUG"
        end
        if radio2.Checked == true then
           level = 1
           levelstr = "INFO"
        end
        if radio3.Checked == true then
           level = 2
           levelstr = "WARNING"
        end
        if radio4.Checked == true then
           level = 3
           levelstr = "ERROR"
        end
        SetLogLevel(level)
        MessageBox.Show("Loglevel " .. level .." activated","Message")
        form:Hide()
    end
end

button.Click:Add(clickButton)

function click()
    if (form~=nill) then
        form:Show()
    end
end

--[[
Required predefined functions: Are called from MultiTail, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
--    if ScriptInitialized == true then
--    end
end

function OnEnter()
	LogMessage(INFO, "InstallPlugin.lua script OnEnter()")
	ScriptInitialized = true

    dropDownItem = ToolStripMenuItem()
    dropDownItem.Text = "Example Plugin"
    dropDownItem.Click:Add(click)
    AddPluginMenuEntry(dropDownItem)
    -- tests the functions above
 	ScriptInitialized = true
end

function OnExit()
	LogMessage(INFO, "InstallPlugin.lua script OnExit()")
 	ScriptInitialized = false  -- prevent OnEvaluate to be called
    if (dropDownItem ~= nill) then
       RemovePluginMenuEntry(dropDownItem)
    end
    if (form ~= nill) then
        form:Dispose()
    end
end

