--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script demonstrates how to start logcat on an android phone and submit the output into
    TailExpert.
]]--
require("Config")

logfile="C:\\temp\\logcat.log"
program = "START /B <PATH to adb.exe> logcat -v threadtime >>" .. logfile
fp1 = nill
fp2 = nill

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
	if ScriptInitialized == true then
		if feof(fp2) ~= true then
			while feof(fp2) ~= true do
				local line = fp2:read("*line")
                outputBuffer = {}
                if line ~= nill then 
                    PutLogLine( line ) 
                end
            end
        else
            LogMessage(INFO, "file is empty")
        end
    end
end

-- Initialize this script
function OnEnter()
	LogMessage(INFO, "ReadAdb.lua script OnEnter()")
    -- tests the functions above
    if file_exists(program) then
		fp1 = io.popen(program)
		
		if (fp1 ~= nil) then
			LogMessage(INFO, "ReadAdb.lua : adb logcat started....")
			if (file_exists(logfile)) then
				lp2 = io:open(logfile)
				if fp2 ~= nil then
					ScriptInitialized = true
				end
			end
		end
	else
		LogMessage(INFO, "ERROR: ReadAdb.lua script cannot find adb.exe !!!")
    end
end

-- Cleanup
function OnExit()
	LogMessage(INFO, "ReadAdb.lua script OnExit())")
	ScriptInitialized = false
    if (fp1 ~= nil) then
        fp1:close()
    end
    if (fp2 ~= nil) then
        fp2:close()
    end
end

