--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script will select loglines in an already opened tab and
    save the loglines to a file 
]]--
require("Config")

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
--    if ScriptInitialized == true then
--    end
end

function OnEnter()
	ScriptInitialized = true
	LogMessage(INFO, "SaveLog.lua script OnEnter()")

    -- tests the functions above
 	ScriptInitialized = true
end

function OnExit()
	LogMessage(INFO, "SaveLog.lua script OnExit()")
 	ScriptInitialized = false  -- prevent Evaluate to be called

	local lastIndex = GetLastIndex("TailExpert.log")
    SelectLogLines("TailExpert.log", 10, lastIndex)
    SaveSelectedLogLines("TailExpert.log", "newlog.log", "US-ASCII", true)
end

