--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script demonstrates how to create a logfile and submit the contents 
    to TailExpert.
]]--
require("Config")

local filename = 'c:\\temp\\wfdlog.log'
local file = nill
local t = nill

function MakeLogMessage(module,severity,message)
    local line
    local dd = GetDateTimeString("yyyy-MM-dd HH:mm:ss:fff")
    line = dd .. " " .. severity .. " " .. message
    return line
end

function CreateLog(file)
    local message
    for i=1,100,1 do
        local temp = math.random(48, 52)
        message = MakeLogMessage("TEST", "INFO", "Temperature = " .. temp .. " C\n")
        file:write(message)
    end
    file:flush()
end

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
	if ScriptInitialized == true then
        local line = file:read("*line")
        if line ~= nill then PrintLine(line) end
    end
end
-- Initialize this script
function OnEnter()
	LogMessage(INFO, "CreateTestLogFileAndOpen.lua script OnEnter()")
    -- tests the functions above
    if file_exists(filename) then
        file = io.open(filename, "a+")
    else
        file = io.open(filename, "w+")
    end
    CreateLog(file)
    file:seek("set", 0)
 	ScriptInitialized = true
end

-- Cleanup
function OnExit()
	LogMessage(INFO, "CreateTestLogFileAndOpen.lua script OnExit()")
	ScriptInitialized = false
    file:close()
end

