function Print(v)
	tb.text = tb.text .. v
end
depth = 0
function dump(t,indent)     
	local names = {}     
	if not indent then 
		indent = "" 
	end     
	for n,g in pairs(t) do         
		table.insert(names,n)     
	end     
	table.sort(names)     
	for i,n in pairs(names) do         
		local v = t[n]         
		if type(v) == "table" then             
			if(v==t) then 
				-- prevent endless loop if table contains reference to itself                 
				Print(indent..tostring(n)..": <-\n")             
			else                 
				Print(indent..tostring(n)..":")                 
				if depth < 6 then
					depth = depth + 1
					dump(v,indent.."   ")
					depth = depth - 1
				end
			end         
		else             
			if type(v) == "function" then                 
				Print(indent..tostring(n).."()\n")             
			else                 
				Print(indent..tostring(n)..": "..tostring(v).."\n")             
			end        
		end     
	end
end 

dump(_G) 
