--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script demonstrates the use of the ZedGraph library available within TailExpert. 
    It will plot a histogram based upon occurrences of actions detected in the TailExpert
    log file. TailExpert debug logging should be enabled to get visible results.
]]--
require("Config")

-- Import WIndows Assemblies
import("System")
import("System.Windows.Forms")
import("System.Windows.Forms.DataVisualization.Charting")
import("System.Drawing")
import("System.Drawing.Drawing2D")
import("System.Color")

local form = Form()
form.Height = 600
form.Width = 800
form.Text = "Output window of HistoExample.lua"
form.HelpButton=false
form.MaximizeBox=true
form.MinimizeBox=true

local chart = Chart()
chart.BackGradientStyle = GradientStyle.TopBottom;
chart.BackColor = Color.WhiteSmoke;
chart.BorderSkin.BorderSkinStyle = BorderSkinStyle.Emboss
chart.BorderSkin.BackGradientStyle = GradientStyle.TopBottom
chart.TextAntiAliasingQuality = TextAntiAliasingQuality.High
chart.Legends[0].BackColor = Color.Transparent
chart.ChartAreas[0].BackColor = Color.Transparent

local xAxis = chart.ChartAreas[0].AxisX
local yAxis = chart.ChartAreas[0].AxisY
local xMin = xAxis.ScaleView.ViewMinimum
local xMax = xAxis.ScaleView.ViewMaximum
local yMin = yAxis.ScaleView.ViewMinimum
local yMax = yAxis.ScaleView.ViewMaximum

-- Set the titles and axis labels
graph.GraphPane.Title.Text = "Bar Graph Example"
graph.GraphPane.XAxis.Title.Text = "Categories"
graph.GraphPane.YAxis.Title.Text = "Nr of Hits"

local label = String[5]
local dbl_arr_x = Double[5]
local dbl_arr_y = Double[5]

for i=0, 4,1 do
    dbl_arr_y[i] = 0.0
    dbl_arr_x[i] = i
end

label[0] = "Pause"
label[1] = "Scroll"
label[2] = "Filter"
label[3] = "Compare"
label[4] = "Bookmarks"

-- Create the three BarItems, change the fill properties so the angle is at 90
-- degrees for horizontal bars
bar = graph.GraphPane.AddBar( 'Function usage', nil, dbl_arr_y, Red )
bar.Bar.Fill = Fill( Red, White, Red, 0 )

-- Set BarBase to the YAxis for horizontal bars
graph.GraphPane.BarSettings.Base = BarBase.X
-- Make the bars stack instead of cluster
graph.GraphPane.BarSettings.Type = BarType.Stack

-- Fill the axis background with a color gradient
graph.GraphPane.Chart.Fill = Fill( Color.White, Color.LightGoldenrodYellow, 45.0 )
graph.GraphPane.XAxis.Scale.TextLabels = label
graph.GraphPane.XAxis.Type = AxisType.Text
graph:AxisChange()

form.Controls:Add(graph)
form:Show()

--[[
Script starts here
]]--

local filename = 'Example2.log'
local file = nill

local linenr = 0
function ReadFile(f)
	-- Do not put message here as it will make a recurring effect when you have log enabled and load TailExpert.log
	outputBuffer = {}
	if ScriptInitialized == true then
		if feof(f) ~= nill then
			while feof(f) ~= true do
				local line = f:read("*line")
				if line ~= nill then 
					PutLogLine( line )
                    
					if string.match(line, "ButtonPause") ~= nil then
                        dbl_arr_y[0] = dbl_arr_y[0] + 1.0
					end
					if string.match(line, "ButtonScroll") ~= nil then
                        dbl_arr_y[1] = dbl_arr_y[1] + 1.0
					end
					if string.match(line, "ButtonFilter") ~= nil then
                        dbl_arr_y[2] = dbl_arr_y[2] + 1.0
					end
					if string.match(line, "compareTabs") ~= nil then
                        dbl_arr_y[3] = dbl_arr_y[3] + 1.0
					end
					if string.match(line, "Bookmark") ~= nil then
                        dbl_arr_y[4] = dbl_arr_y[4] + 1.0
					end
					if string.match(line, "find") ~= nil then
                        dbl_arr_y[4] = dbl_arr_y[4] + 1.0
					end
				end
                -- Create new pointPairList
                pointPairList = PointPairList()
                pointPairList:Add(nil, dbl_arr)
                curveItem = myPane.CurveList[0]
                curveItem.Points = pointPairList
                graph:AxisChange()
                graph:Refresh()
			end
		end
	end
end

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
    if ScriptInitialized == true then
        ReadFile(file)
    end
end

function OnEnter()
	LogMessage(INFO, "HistoExample.lua script OnEnter()")
	ScriptInitialized = true

    -- tests the functions above
    if file_exists(filename) then
        file = assert(io.open(filename, "r"))
    end
    file:seek("set", 0)
 	ScriptInitialized = true
end

function OnExit()
	LogMessage(INFO, "HistoExample.lua script OnExit()")
 	ScriptInitialized = false  -- prevent Evaluate to be called
    graph:Dispose()
    form:Close()
	file:close()
end

