--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script will read a file named TailExpert.log from the temp directory 
    and submit it to TailExpert, all occurences of the word `error` will be 
    converted to uppercase before submission
]]--
require("Config")

-- Import Windows Assemblies
import("System.Windows.Forms")
import("System.Drawing")

local lv = ListView()
lv.View = View.Details
lv.Dock = DockStyle.Fill
lv.FullRowSelect = true
lv.Columns:Add("Test", "Test Synopsis")
lv.Columns["Test"].Width = 700
lv.Columns:Add("Results", "Results")
lv.Columns["Results"].Width = 150


local item = ListViewItem()
item.Text = "Test Case 1: Check State Machine"
item.SubItems:Add("")
lv.Items:Add(item)
item.BackColor = Color.LightBlue
item = ListViewItem()
item.Text = "Test Case 2: Check Condition 2"
item.SubItems:Add("")
lv.Items:Add(item)
item.BackColor = Color.White
item = ListViewItem()
item.Text = "Test Case 3: Check Condition 3"
item.SubItems:Add("")
lv.Items:Add(item)
item.BackColor = Color.LightBlue

item = lv:get_Items():get_Item(0)
subItem = item:get_SubItems():get_Item(1)
subItem:set_Text("In Progress...")

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
	if ScriptInitialized == true then
    end
end

-- Initialize this script
function OnEnter()
	LogMessage(INFO, "OpenCustomTab.lua script OnEnter()")
    -- tests the functions above
    local tab = OpenCustomTab("OpenCustomTab", false)
	tab.Controls:Add(lv)
end

-- Cleanup
function OnExit()
	LogMessage(INFO, "OpenCustomTab.lua script OnExit()")
	CloseTab("OpenCustomTab")
   	ScriptInitialized = false
end

