--[[
    This is an example script for the lua engine in TailExpert
    
    Purpose:
    This script will read a file named TailExpert.log from the temp directory 
    and submit it to TailExpert, the script will search for messages that indicate
	the usage of internal functions. To get a visible bargraph the 
	TailExpert debuglogging should be enabled to get the logfile filled with 
	the required debug messages.
]]--
require("Config")

-- Import Windows Assemblies
import("System")
import("System.Windows.Forms")
import("System.Drawing")
import("System.Drawing.Drawing2D")
import("ZedGraph") 
local graph = ZedGraphControl()
graph.Dock = DockStyle.Fill
myPane = graph.GraphPane

-- Set the titles and axis labels
myPane.Title.Text = "Bar Graph Example"
myPane.XAxis.Title.Text = "Categories"
myPane.YAxis.Title.Text = "Nr of Hits"

local label = String[7]
local dbl_arr = Double[7]

for i=0, 6,1 do
    dbl_arr[i] = 0.0
end

label[0] = "Pause"
label[1] = "Scroll"
label[2] = "Filter"
label[3] = "Compare"
label[4] = "Bookmarks"
label[5] = "Bookmarks"
label[6] = "Group"

-- Create the three BarItems, change the fill properties so the angle is at 90
-- degrees for horizontal bars
bar = myPane:AddBar( "Function usage", nil, dbl_arr, Color.Red )
bar.Bar.Fill = Fill( Color.Red, Color.White, Color.Red, 0 )

-- Set BarBase to the YAxis for horizontal bars
myPane.BarSettings.Base = BarBase.X
-- Make the bars stack instead of cluster
myPane.BarSettings.Type = BarType.Stack

-- Fill the axis background with a color gradient
myPane.Chart.Fill = Fill( Color.White, Color.LightGoldenrodYellow, 45.0 )
myPane.XAxis.Scale.TextLabels = label
myPane.XAxis.Type = AxisType.Text
graph:AxisChange()

local filename = 'Example2.log'
local file = nill

local linenr = 0
function ReadFile(f)
	-- Do not put message here as it will make a recurring effect when you have log enabled and load TailExpert.log
	outputBuffer = {}
	if ScriptInitialized == true then
		if feof(f) ~= nill then
			while feof(f) ~= true do
				local line = f:read("*line")
				if line ~= nill then 
					PutLogLine( line )
                    
					if string.match(line, "ButtonPause") ~= nil then
                        dbl_arr[0] = dbl_arr[0] + 1.0
					end
					if string.match(line, "ButtonScroll") ~= nil then
                        dbl_arr[1] = dbl_arr[1] + 1.0
					end
					if string.match(line, "ButtonFilter") ~= nil then
                        dbl_arr[2] = dbl_arr[2] + 1.0
					end
					if string.match(line, "compareTabs") ~= nil then
                        dbl_arr[3] = dbl_arr[3] + 1.0
					end
					if string.match(line, "Bookmark") ~= nil then
                        dbl_arr[4] = dbl_arr[4] + 1.0
					end
					if string.match(line, "find") ~= nil then
                        dbl_arr[5] = dbl_arr[5] + 1.0
					end
					if string.match(line, "Group") ~= nil then
                        dbl_arr[6] = dbl_arr[6] + 1.0
					end
				end
                -- Create new pointPairList
                pointPairList = PointPairList()
                pointPairList:Add(nil, dbl_arr)
                curveItem = myPane.CurveList[0]
                curveItem.Points = pointPairList
                graph:AxisChange()
                graph:Refresh()
			end
		end
	end
end

--[[
Required predefined functions: Are called from TailExpert, adapt to your needs
]]--

function OnEvaluate(loglines)
    -- Do not put LogMessage() here this will overflow your logs as
    -- Evaluate is called every tail cycle
    -- If you need log make sure it's not output every cycle
    if ScriptInitialized == true then
        ReadFile(file)
    end
end

-- Initialize this script
function OnEnter()
	LogMessage(INFO, "OpenCustomTab2.lua script OnEnter()")
    -- tests the functions above
	ScriptInitialized = true

    -- tests the functions above
    if file_exists(filename) then
        file = assert(io.open(filename, "r"))
    end
    file:seek("set", 0)
    local tab = OpenCustomTab("OpenCustomTab2", false);
	tab.Controls:Add(graph)
end

-- Cleanup
function OnExit()
	LogMessage(INFO, "OpenCustomTab2.lua script OnExit()")
    graph:Dispose()
	file:close()
	CloseTab("OpenCustomTab2")
   	ScriptInitialized = false
end

